clear

filename = uigetfile('*.hpl');
[fileID,errmsg] = fopen(filename);
Data = textscan(fileID,'%f%f%f%f', 'Headerlines', 17)

A= Data{1,1};
B= Data{1,2};
C= Data{1,3};
D= Data{1,4};

times= A(1:641:46152,1);
azimuths= B(1:641:46152,1);
elevations= C(1:641:46152,1);

times70= times(1:36);
times80= times(37:72);
azimuths70= azimuths(1:36);
azimuths80= azimuths(37:72);
elevations70= elevations(1:36);
elevations80= elevations(37:72);

r= (30 + [0:3:1919]).';
for i= 1:72
    range_gate(((((i-1)*639)+i) : ((((i-1)*639)+i)+639)),1) = A((((i-1)*640)+(i+1)) : ((((i-1)*640)+(i+1))+639));
    ranges(((((i-1)*639)+i) : ((((i-1)*639)+i)+639)),1) = r;
    Doppler(((((i-1)*639)+i) : ((((i-1)*639)+i)+639)),1) = B((((i-1)*640)+(i+1)) : ((((i-1)*640)+(i+1))+639));
    intensity(((((i-1)*639)+i) : ((((i-1)*639)+i)+639)),1) = C((((i-1)*640)+(i+1)) : ((((i-1)*640)+(i+1))+639));
    beta(((((i-1)*639)+i) : ((((i-1)*639)+i)+639)),1) = D((((i-1)*640)+(i+1)) : ((((i-1)*640)+(i+1))+639));
end

range_gate70= range_gate(1:23040);
range_gate80= range_gate(23041:46080);
ranges70= ranges(1:23040);
ranges80= ranges(23041:46080);
Doppler70= Doppler(1:23040);
Doppler80= Doppler(23041:46080);
intensity70= intensity(1:23040);
intensity80= intensity(23041:46080);
beta70= beta(1:23040);
beta80= beta(23041:46080);

go_or_no=1;
while go_or_no==1
    desired_elevation_angle= input('What is the elevation angle of the profiles you would like to examine? Please enter 70 or 80: ');
    while (desired_elevation_angle ~=70) && (desired_elevation_angle ~= 80)
        desired_elevation_angle= input('The elevation angle you entered is invalid. Please enter 70 or 80: ');
    end
    
    desired_azimuthal_axis1= input('What is the azimuthal axis of the profiles you would like to compare? Please enter an integer value between 1 and 18: ');
    desired_azimuthal_axis1= floor(desired_azimuthal_axis1);
    while (desired_azimuthal_axis1 <1) || (desired_azimuthal_axis1 > 18)
        desired_azimuthal_axis1= input('The azimuthal axis you entered is invalid. Please enter an integer value between 1 and 18: ');
    end
    desired_azimuthal_axis2= desired_azimuthal_axis1 + 18;
    
    if desired_elevation_angle== 70
        figure
        subplot(1,3,1)
        set(gcf,'Color', 'w');
        plot( Doppler70(((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+5 : ((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+639))), ranges70(((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+5 : ((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+639))),'Color' ,[0.6350 0.0780 0.1840], 'LineWidth',2 )
        xlabel('radial wind speed (m/s)');
        ylabel('range (m)');
        title('Doppler Profile');
        ax = gca;
        ax.FontSize = 12;
        ax.Color = [0.8 0.8 0.8];
        subplot(1,3,3)
        plot( Doppler70(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+5 : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))), ranges70(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+5 : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))), 'LineWidth',2 )
        xlabel('radial wind speed (m/s)');
        ylabel('range (m)');
        title('Doppler Profile');
        ax = gca;
        ax.FontSize = 12;
        ax.Color = [0.8 0.8 0.8];
        AZ70_1= ones(640,1);
        AZ70_1= azimuths70(desired_azimuthal_axis1)*AZ70_1;
        AZ70_1= (pi/180)*AZ70_1;
        AZ70_2= ones(640,1);
        AZ70_2= azimuths70(desired_azimuthal_axis2)*AZ70_2;
        AZ70_2= (pi/180)*AZ70_2;
        EL= ones(640,1);
        EL= (pi/180)*70*EL;
        subplot(1,3,2)
        [x1,y1,z1] = sph2cart(AZ70_1,EL,ranges70(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1) : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))));
        [x2,y2,z2] = sph2cart(AZ70_2,EL,ranges70(((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2) : ((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+639))));
        plot3(x1,-y1,z1,'LineWidth',2)
        hold on
        plot3(x2,-y2,z2,'Color' ,[0.6350 0.0780 0.1840], 'LineWidth',2)
        entered_axis = int2str(desired_azimuthal_axis1);
        title(strcat('Profiles along Azimuthal Axis ', {' '}, entered_axis));
        ylabel('y (m)');
        xlabel('x (m)');
        zlabel('z (m)');
        hold on
        R= ones(36,1);
        R= max(ranges70(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+5 : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))))*R;
        [x3,y3,z3] = sph2cart(azimuths70(:),EL(1:36),R); 
        plot3(x3,-y3,z3,'.k')
        grid on
        ax = gca;
        ax.FontSize = 12;
        ax.Color = [0.8 0.8 0.8];
        text(500,0,'N');
        text(0,-500,'E');
        text(-500,0,'S');
        text(0,500,'W');
    else
        figure
        subplot(1,3,1)
        set(gcf,'Color', 'w');
        plot( Doppler80(((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+5 : ((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+639))), ranges80(((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+5 : ((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+639))),'Color' ,[0.6350 0.0780 0.1840], 'LineWidth',2 )
        xlabel('radial wind speed (m/s)');
        ylabel('range (m)');
        title('Doppler Profile');
        ax = gca;
        ax.FontSize = 12;
        ax.Color = [0.8 0.8 0.8];
        subplot(1,3,3)
        plot( Doppler80(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+5 : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))), ranges80(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+5 : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))), 'LineWidth',2 )
        xlabel('radial wind speed (m/s)');
        ylabel('range (m)');
        title('Doppler Profile');
        ax = gca;
        ax.FontSize = 12;
        ax.Color = [0.8 0.8 0.8];
        AZ80_1= ones(640,1);
        AZ80_1= azimuths80(desired_azimuthal_axis1)*AZ80_1;
        AZ80_1= (pi/180)*AZ80_1;
        AZ80_2= ones(640,1);
        AZ80_2= azimuths80(desired_azimuthal_axis2)*AZ80_2;
        AZ80_2= (pi/180)*AZ80_2;
        EL= ones(640,1);
        EL= (pi/180)*80*EL;
        subplot(1,3,2)
        [x1,y1,z1] = sph2cart(AZ80_1,EL,ranges80(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1) : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))));
        [x2,y2,z2] = sph2cart(AZ80_2,EL,ranges80(((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2) : ((((desired_azimuthal_axis2-1)*639)+desired_azimuthal_axis2)+639))));
        plot3(x1,-y1,z1,'LineWidth',2)
        hold on
        plot3(x2,-y2,z2,'Color' ,[0.6350 0.0780 0.1840], 'LineWidth',2)
        entered_axis = int2str(desired_azimuthal_axis1);
        title(strcat('Profiles along Azimuthal Axis ', {' '}, entered_axis));
        ylabel('y (m)');
        xlabel('x (m)');
        zlabel('z (m)');
        hold on
        R= ones(36,1);
        R= max(ranges80(((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+5 : ((((desired_azimuthal_axis1-1)*639)+desired_azimuthal_axis1)+639))))*R;
        [x3,y3,z3] = sph2cart(azimuths80(:),EL(1:36),R); 
        plot3(x3,-y3,z3,'.k')
        grid on
        ax = gca;
        ax.FontSize = 12;
        ax.Color = [0.8 0.8 0.8];
        text(350,0,'N');
        text(0,-350,'E');
        text(-350,0,'S');
        text(0,350,'W');
    end
    
        
    go_or_no= input('Would you like to examine a different azimuthal axis?  Enter "1" for yes, "0" for no: ');
    if (go_or_no ~= 0) && (go_or_no ~= 1)
        go_or_no= input('You have entered an invalid entry. Please enter "1" for yes, or "0" for no: ');
    end
end
